(*| 22:43 27/05/1994 *)
UNIT Archives;

INTERFACE

USES Dos;

TYPE
  TArchiveType = (TArc, TLzh, TArj, TZip);
  ArchiveProc = PROCEDURE(FileText: PathStr;
                          FTimeDate, FSize: LongInt;
                          FAttr: Word;
                          ArcType: TArchiveType;
                          ArcLevel: Integer);

VAR
  RecurseArc: Boolean;

PROCEDURE ProcessThisArcFile(FName:PathStr; AP: ArchiveProc);

PROCEDURE ProcessThisLzhFile(FName:PathStr; AP: ArchiveProc);

PROCEDURE ProcessThisZipFile(FName:PathStr; AP: ArchiveProc);

PROCEDURE ProcessThisArjFile(FName:PathStr; AP: ArchiveProc);

PROCEDURE RecurseCheck(FPos: LongInt; FName: PathStr; AP: ArchiveProc);

IMPLEMENTATION

CONST
  ADPakSize = 29;
  JDPakSize = 34;
  JDSig=$EA60;
  LDPakSize = 22;
  LDPakSize2 = 5;
  LDSig = $00686C2D; {'-lh''?'}
  ZDPakSize = 30;
  ZDLocalSig = $04034B50;
  ZDCenSig = $02014B50;

TYPE
  ADClass= (ByteADClass, StrucADClass);
  ArcDirType= RECORD
                CASE ADClass OF
                  ByteADClass:(ADByte     : ARRAY[0..ADPakSize-1] OF Byte);
                  StrucADClass:(ADEOF     : Byte;
                                ADStyle   : Byte;
                                ADName    : ARRAY[1..13] OF Char;
                                ADSizeNow : LongInt;
                                ADDate    : Word;
                                ADTime    : Word;
                                ADCrc     : Word;
                                ADSize    : LongInt);
              END;
  JDClass= (ByteJDClass, StrucJDClass);
  ArjDirType= RECORD
                CASE JDClass OF
                  ByteJDClass:(JDByte     : ARRAY[0..JDPakSize-1] OF Byte);
                  StrucJDClass:(JDSignatur: Word;
                                JDHdrLen  : Word;
                                JDHdr1Len : Byte;
                                JDVer     : Byte;
                                JDMinVer  : Byte;
                                JDHostOS  : Byte;
                                JDFlags   : Byte;
                                JDMethod  : Byte;
                                JDFType   : Byte;
                                JDMisc1   : Byte;
                                JDTimeDate: LongInt;
                                JDSizeNow : LongInt;
                                JDSize    : LongInt;
                                JDFCrc    : LongInt;
                                JDMisc2   : Word;
                                JDAttr    : Byte;
                                JDAtt2    : Byte;
                                JDMisc3   : Word);
              END;
  LDClass= (ByteLDClass, StrucLDClass);
  LzhDirType= RECORD
                CASE LDClass OF
                  ByteLDClass:(LDByte     : ARRAY[0..LDPakSize-1] OF Byte);
                  StrucLDClass:(LDHdrLen  : Byte;  {upto CRC+1}
                                LDHdrSum  : Byte;
                                LDSignatur: LongInt; {type as 5 bytes}
                                LDSig2    : Byte;
                                LDSizeNow : LongInt;
                                LDSize    : LongInt;
                                LDTimeDate: LongInt;
                                LDAttr    : Byte;
                                LDMisc2   : Byte;  {word storage for attr?}
                                LDNameLen : Byte);
              END;
  ZDClass= (ByteZDClass, StrucZDClass);
  ZipDirType= RECORD
                CASE ZDClass OF
                  ByteZDClass:(ZDByte     : ARRAY[0..ZDPakSize-1] OF Byte);
                  StrucZDClass:(ZDSignatur: LongInt;
                                ZDExtVer  : Word;
                                ZDFlag    : Word;
                                ZDStyle   : Word;
                                ZDTimeDate: LongInt;

(*                              ZDTime    : Word;
                                ZDDate    : Word;*)

                                ZDCrc     : LongInt;
                                ZDSizeNow : LongInt;
                                ZDSize    : LongInt;
                                ZDNameLen : Word;
                                ZDExtraLen: Word);
              END;

VAR
  ArchiveFile: File OF Byte;
  ArcLevel: Integer;

FUNCTION NextByte: Byte;
VAR
  NB: Byte;
BEGIN
  IF Eof(ArchiveFile) THEN
    NB := 0
  ELSE
    Read(ArchiveFile, NB);
  NextByte:=NB;
END;  { NextByte }

FUNCTION NextWord: Word;
VAR
  NW: Word;
BEGIN
  NW := NextByte;
  NextWord := NW + (NextByte SHL 8);
END;  { NextWord }

FUNCTION NextLongInt: LongInt;
VAR
  NLI: LongInt;
BEGIN
  NLI := NextWord;
  NextLongInt := NLI + (LongInt(NextWord) SHL 16);
END;  { NextLongInt }

PROCEDURE NextArcEntry(VAR ArcDir: ArcDirType; VAR FilePos: LongInt);
VAR
  I: Integer;
BEGIN
  WITH ArcDir DO BEGIN
    ADStyle := 0;
    Seek(ArchiveFile, FilePos);
    ADByte[0] := NextByte;
    IF ADEOF = $1A THEN BEGIN
      ADByte[1] := NextByte;
      IF ADStyle <> 0 THEN BEGIN
        FOR I := 2 TO ADPakSize-1 DO
          ADByte[I] := NextByte;
        FilePos:=FilePos + ADSizeNow + ADPakSize;
      END;
    END;
  END;
END;  { NextArcEntry }

PROCEDURE ArcDirInfo(ArcDir: ArcDirType;
                     VAR ThisFilePos: LongInt;
                     Sign: Char;
                     AP: ArchiveProc);
VAR
  PackDT: LongInt;
  I: Integer;
  ThisName: PathStr;
BEGIN
  WITH ArcDir DO BEGIN
    ThisName := '';
    I := 0;
    REPEAT
      INC(I);
      IF ADName[I] <> #0 THEN
        ThisName := ThisName + ADName[I];
    UNTIL ADName[I] = #0;
    PackDT := LongInt(ADDate) SHL 16;
    PackDT := PackDT + ADTime;
    AP(ThisName, PackDT, ADSize, 0, TArc, ArcLevel);
    IF (ADStyle = 2) AND RecurseArc THEN
      RecurseCheck(ThisFilePos + ADPakSize, ThisName, AP);
  END;
END;  { ArcDirInfo }

PROCEDURE ProcessThisArcFile(FName:PathStr; AP: ArchiveProc);
VAR
  ArcDir: ArcDirType;
  OldFilePos,FilePos: LongInt;
BEGIN
  ASSIGN(ArchiveFile, FName);
{$I-}
  RESET(ArchiveFile);
{$I+}
  IF IOResult = 0 THEN WITH ArcDir DO BEGIN
    FilePos := 0;
    ArcLevel := 1;
    REPEAT
      OldFilePos := FilePos;
      NextArcEntry(ArcDir, FilePos);
      IF ADStyle <> 0 THEN
        ArcDirInfo(ArcDir, OldFilePos, '+', AP);
    UNTIL ADStyle = 0;
    Close(ArchiveFile);
  END;
END; { ProcessThisArcFile }

FUNCTION ValidLzhSig(LzhDir: LzhDirType): Boolean;
VAR
  CopySig: LongInt;
BEGIN
  WITH LzhDir DO BEGIN
    CopySig := LDSignatur AND $00FFFFFF;
    ValidLzhSig := (CopySig = LDSig) AND (LDSig2 = $2D);
  END;
END;  { ValidLzhSig }

PROCEDURE NextLzhEntry(VAR LzhDir: LzhDirType; VAR FilePos: LongINt);
VAR
  I: Integer;
BEGIN
  WITH LzhDir DO BEGIN
    Seek(ArchiveFile, FilePos);
    FOR I := 0 TO LDPakSize-1 DO
      LDByte[I] := NextByte;
    IF ValidLzhSig(LzhDir) THEN BEGIN
      FilePos := FilePos + LDSizeNow + LDNameLen + LDPakSize + LDPakSize2;
    END;
  END;
END;  { NextLzhEntry }

PROCEDURE LzhDirInfo(LzhDir: LzhDirType;
                     VAR ThisFilePos: LongInt;
                     Sign: Char;
                     AP: ArchiveProc);
VAR
  I: Integer;
  ThisName: PathStr;
  OldFilePos, NewFilePos: LongInt;
  LDStyle: CHAR;
BEGIN
  WITH LzhDir DO BEGIN
    LDStyle := CHR(LDByte[5]);
    ThisName := '';
    FOR I := 1 TO LDNameLen DO
      ThisName := ThisName + CHR(NextByte);
    AP(ThisName, LDTimeDate, LDSize, 0, TLzh, ArcLevel);
    IF (LDStyle = '0') AND RecurseArc THEN
      RecurseCheck(ThisFilePos + LDNameLen + LDPakSize + LDPakSize2,
                   ThisName, AP);
  END;
END;  { LzhDirInfo }

PROCEDURE ProcessThisLzhFile(FName:PathStr; AP: ArchiveProc);
VAR
  LzhDir: LzhDirType;
  OldFilePos, FilePos: LongInt;
BEGIN
  ASSIGN(ArchiveFile, FName);
{$I-}
  RESET(ArchiveFile);
{$I+}
  IF IOResult = 0 THEN WITH LzhDir DO BEGIN
    FilePos := 0;
    ArcLevel := 1;
    REPEAT
      OldFilePos := FilePos;
      NextLzhEntry(LzhDir, FilePos);
      IF ValidLzhSig(LzhDir) THEN
        LzhDirInfo(LzhDir, OldFilePos, '+', AP);
    UNTIL NOT ValidLzhSig(LzhDir);
    Close(ArchiveFile);
  END;
END; { ProcessThisLzhFile }

PROCEDURE NextZipEntry(VAR ZipDir: ZipDirType; VAR FilePos: LongInt);
VAR
  I: Integer;
BEGIN
  WITH ZipDir DO BEGIN
    Seek(ArchiveFile, FilePos);
    FOR I := 0 TO ZDPakSize-1 DO
      ZDByte[I] := NextByte;
    IF ZDSignatur = ZDLocalSig THEN BEGIN
      FilePos := FilePos + ZDSizeNow + ZDNameLen + ZDExtraLen + ZDPakSize;
    END;
  END;
END;  { NextZipEntry }

PROCEDURE ZipDirInfo(ZipDir: ZipDirType;
                     VAR ThisFilePos: LongInt;
                     Sign: Char;
                     AP: ArchiveProc);
VAR
  I: Integer;
  ThisName: PathStr;
BEGIN
  WITH ZipDir DO BEGIN
    ThisName := '';
    FOR I := 1 TO ZDNameLen DO
      ThisName := ThisName + CHR(NextByte);
    AP(ThisName, ZDTimeDate, ZDSize, 0, TZip, ArcLevel);
    IF (ZDStyle = 0) AND RecurseArc THEN
      RecurseCheck(ThisFilePos + ZDPakSize + ZDNameLen, ThisName, AP);
  END;
END;  { ZipDirInfo }

PROCEDURE ProcessThisZipFile(FName: PathStr; AP: ArchiveProc);
VAR
  ZipDir: ZipDirType;
  OldFilePos,FilePos: LongInt;
BEGIN
  ASSIGN(ArchiveFile, FName);
{$I-}
  RESET(ArchiveFile);
{$I+}
  IF IOResult = 0 THEN WITH ZipDir DO BEGIN
    FilePos := 0;
    ArcLevel := 1;
    REPEAT
      OldFilePos := FilePos;
      NextZipEntry(ZipDir, FilePos);
      IF ZDSignatur = ZDLocalSig THEN
        ZipDirInfo(ZipDir, OldFilePos, '+', AP);
    UNTIL ZDSignatur <> ZDLocalSig;
    Close(ArchiveFile);
  END;
END; { ProcessThisZipFile }

PROCEDURE NextArjEntry(VAR ArjDir: ArjDirType; VAR FilePos: LongInt);
VAR
  I: Integer;
BEGIN
  WITH ArjDir DO BEGIN
    Seek(ArchiveFile, FilePos);
    FOR I := 0 TO JDPakSize-1 DO
      JDByte[I] := NextByte;
    IF JDHdrLen > 0 THEN BEGIN
      FilePos := FilePos + JDSizeNow + JDHdrLen + 4 + 6;
    END;
  END;
END;  { NextArjEntry }

PROCEDURE ArjDirInfo(ArjDir: ArjDirType;
                     VAR ThisFilePos: LongInt;
                     Sign: Char;
                     AP: ArchiveProc);
VAR
  I: Integer;
  ThisName: PathStr;
  OldFilePos, NewFilePos: LongInt;
BEGIN
  WITH ArjDir DO BEGIN
    ThisName := '';
    REPEAT
      I := NextByte;
      IF I > 0 THEN
        ThisName := ThisName + CHR(I);
    UNTIL I = 0;
    AP(ThisName, JDTimeDate, JDSize, 0, TArj, ArcLevel);
    IF {(IF JDStyle = 0) AND} RecurseArc THEN
      RecurseCheck(ThisFilePos + JDHdrLen, ThisName, AP);
  END;
END;

PROCEDURE ProcessThisArjFile(FName: PathStr; AP: ArchiveProc);
VAR
  ArjDir: ArjDirType;
  OldFilePos, FilePos: LongInt;
BEGIN
  ASSIGN(ArchiveFile, FName);
{$I-}
  RESET(ArchiveFile);
{$I+}
  IF IOResult = 0 THEN WITH ArjDir DO BEGIN
    FilePos := 0;
    ArcLevel := 1;
    IF NextWord <> JDSig THEN
      EXIT;
    FilePos := NextWord + 4 + 6;
    REPEAT
      OldFilePos := FilePos;
      NextArjEntry(ArjDir, FilePos);
      IF JDHdrLen > 0 THEN
        ArjDirInfo(ArjDir, OldFilePos, '+', AP);
    UNTIL JDHdrLen = 0;
    Close(ArchiveFile);
  END;
END; { ProcessThisArjFile }

PROCEDURE RecurseCheck(FPos: LongInt; FName: PathStr; AP: ArchiveProc);
VAR
  NewFilePos, OldFilePos: LongInt;
  ArcDir: ArcDirType;
  ArjDir: ArjDirType;
  LzhDir: LzhDirType;
  ZipDir: ZipDirType;
BEGIN
  NewFilePos := FPos;
  IF POS('.ZIP',FName) <> 0 THEN WITH ZipDir DO BEGIN
    REPEAT
      OldFilePos := NewFilePos;
      NextZipEntry(ZipDir, NewFilePos);
      IF ZDSignatur = ZDLocalSig THEN BEGIN
        INC(ArcLevel);
        ZipDirInfo(ZipDir, OldFilePos, '*', AP);
        DEC(ArcLevel);
      END;
    UNTIL ZDSignatur <> ZDLocalSig;
  END ELSE IF POS('.ARJ', FName) <> 0 THEN WITH ArjDir DO BEGIN
    Seek(ArchiveFile, NewFilePos);
    IF NextWord <> JDSig THEN
      EXIT;
    NewFilePos := NewFilePos + NextWord + 4 + 6;
    REPEAT
      OldFilePos := NewFilePos;
      NextArjEntry(ArjDir, NewFilePos);
      IF JDHdrLen > 0 THEN BEGIN
        INC(ArcLevel);
        ArjDirInfo(ArjDir, OldFilePos, '*', AP);
        DEC(ArcLevel);
      END;
    UNTIL JDHdrLen = 0;
  END ELSE IF POS('.ARC', FName) <> 0 THEN WITH ArcDir DO BEGIN
    REPEAT
      OldFilePos := NewFilePos;
      NextArcEntry(ArcDir, NewFilePos);
      IF ADStyle <> 0 THEN BEGIN
        INC(ArcLevel);
        ArcDirInfo(ArcDir, OldFilePos, '*', AP);
        DEC(ArcLevel);
      END;
    UNTIL ADStyle=0;
  END ELSE IF POS('.LZH', FName) <> 0 THEN WITH LzhDir DO BEGIN
    REPEAT
      OldFilePos := NewFilePos;
      NextLzhEntry(LzhDir, NewFilePos);
      IF ValidLzhSig(LzhDir) THEN BEGIN
        INC(ArcLevel);
        LzhDirInfo(LzhDir, OldFilePos, '*', AP);
        DEC(ArcLevel);
      END;
    UNTIL NOT ValidLzhSig(LzhDir);
  END;
END;  { RecurseCheck }

BEGIN
  RecurseArc := True;
END.
